"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, migration_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides details about an ongoing or complete migration from an Amazon Lex V1 bot to an Amazon Lex V2 bot. Use this operation to view the migration alerts and warnings related to the migration.

    Args:
        migration_id(str): The unique identifier of the migration to view. The migrationID is returned by the operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.migration.get(ctx, migration_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.migration.get migration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_migration",
        op_kwargs={"migrationId": migration_id},
    )


async def get_all(
    hub,
    ctx,
    sort_by_attribute: str = None,
    sort_by_order: str = None,
    v1_bot_name_contains: str = None,
    migration_status_equals: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of migrations between Amazon Lex V1 and Amazon Lex V2.

    Args:
        sort_by_attribute(str, optional): The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time that the migration was started. Defaults to None.
        sort_by_order(str, optional): The order so sort the list. Defaults to None.
        v1_bot_name_contains(str, optional): Filters the list to contain only bots whose name contains the specified string. The string is matched anywhere in bot name. Defaults to None.
        migration_status_equals(str, optional): Filters the list to contain only migrations in the specified state. Defaults to None.
        max_results(int, optional): The maximum number of migrations to return in the response. The default is 10. Defaults to None.
        next_token(str, optional): A pagination token that fetches the next page of migrations. If the response to this operation is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of migrations, specify the pagination token in the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.migration.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.migration.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_migrations",
        op_kwargs={
            "sortByAttribute": sort_by_attribute,
            "sortByOrder": sort_by_order,
            "v1BotNameContains": v1_bot_name_contains,
            "migrationStatusEquals": migration_status_equals,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    v1_bot_name: str,
    v1_bot_version: str,
    v2_bot_name: str,
    v2_bot_role: str,
    migration_strategy: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2. Migrate your bot when you want to take advantage of the new features of Amazon Lex V2. For more information, see Migrating a bot in the Amazon Lex developer guide.

    Args:
        v1_bot_name(str): The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
        v1_bot_version(str): The version of the bot to migrate to Amazon Lex V2. You can migrate the $LATEST version as well as any numbered version.
        v2_bot_name(str): The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to.    If the Amazon Lex V2 bot doesn't exist, you must use the CREATE_NEW migration strategy.   If the Amazon Lex V2 bot exists, you must use the UPDATE_EXISTING migration strategy to change the contents of the Amazon Lex V2 bot.  .
        v2_bot_role(str): The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
        migration_strategy(str): The strategy used to conduct the migration.    CREATE_NEW - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.    UPDATE_EXISTING - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is created in the Amazon Lex V2 bot.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.migration.start(
                ctx,
                v1_bot_name=value,
                v1_bot_version=value,
                v2_bot_name=value,
                v2_bot_role=value,
                migration_strategy=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.migration.start v1_bot_name=value, v1_bot_version=value, v2_bot_name=value, v2_bot_role=value, migration_strategy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="start_migration",
        op_kwargs={
            "v1BotName": v1_bot_name,
            "v1BotVersion": v1_bot_version,
            "v2BotName": v2_bot_name,
            "v2BotRole": v2_bot_role,
            "migrationStrategy": migration_strategy,
        },
    )
