"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, checksum: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of an intent based on the $LATEST version of the intent. If the $LATEST version of this intent hasn't changed since you last updated it, Amazon Lex doesn't create a new version. It returns the last version you created.  You can update only the $LATEST version of the intent. You can't update the numbered versions that you create with the CreateIntentVersion operation.   When you create a version of an intent, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see versioning-intro.  This operation requires permissions to perform the lex:CreateIntentVersion action.

    Args:
        name(str): The name of the intent that you want to create a new version of. The name is case sensitive. .
        checksum(str, optional): Checksum of the $LATEST version of the intent that should be used to create the new version. If you specify a checksum and the $LATEST version of the intent has a different checksum, Amazon Lex returns a PreconditionFailedException exception and doesn't publish a new version. If you don't specify a checksum, Amazon Lex publishes the $LATEST version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.intent.version.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.intent.version.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="create_intent_version",
        op_kwargs={"name": name, "checksum": checksum},
    )


async def delete(hub, ctx, name: str, version: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a specific version of an intent. To delete all versions of a intent, use the DeleteIntent operation.  This operation requires permissions for the lex:DeleteIntentVersion action.

    Args:
        name(str): The name of the intent.
        version(str): The version of the intent to delete. You cannot delete the $LATEST version of the intent. To delete the $LATEST version, use the DeleteIntent operation.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.intent.version.delete(ctx, name=value, version=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.intent.version.delete name=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="delete_intent_version",
        op_kwargs={"name": name, "version": version},
    )


async def get_all(
    hub, ctx, name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about all of the versions of an intent. The GetIntentVersions operation returns an IntentMetadata object for each version of an intent. For example, if an intent has three numbered versions, the GetIntentVersions operation returns four IntentMetadata objects in the response, one for each numbered version and one for the $LATEST version.  The GetIntentVersions operation always returns at least one version, the $LATEST version. This operation requires permissions for the lex:GetIntentVersions action.

    Args:
        name(str): The name of the intent for which versions should be returned.
        next_token(str, optional): A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. . Defaults to None.
        max_results(int, optional): The maximum number of intent versions to return in the response. The default is 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.intent.version.get_all(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.intent.version.get_all name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_intent_versions",
        op_kwargs={"name": name, "nextToken": next_token, "maxResults": max_results},
    )
