"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "import"


async def get(hub, ctx, import_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about an import job started with the StartImport operation.

    Args:
        import_id(str): The identifier of the import job information to return.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.import_.get(ctx, import_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.import.get import_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_import",
        op_kwargs={"importId": import_id},
    )


async def start(
    hub, ctx, payload: bytes, resource_type: str, merge_strategy: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a job to import a resource to Amazon Lex.

    Args:
        payload(bytes): A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to import. The resource should match the type specified in the resourceType field.
        resource_type(str): Specifies the type of resource to export. Each resource also exports any resources that it depends on.    A bot exports dependent intents.   An intent exports dependent slot types.  .
        merge_strategy(str): Specifies the action that the StartImport operation should take when there is an existing resource with the same name.   FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file and an existing resource. The name of the resource causing the conflict is in the failureReason field of the response to the GetImport operation. OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The $LASTEST version of the existing resource is overwritten with the data from the import file.  .
        tags(List, optional): A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add tags to an intent or slot type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.import_.start(
                ctx, payload=value, resource_type=value, merge_strategy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.import.start payload=value, resource_type=value, merge_strategy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="start_import",
        op_kwargs={
            "payload": payload,
            "resourceType": resource_type,
            "mergeStrategy": merge_strategy,
            "tags": tags,
        },
    )
