"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "slot_type"


async def get_all(
    hub,
    ctx,
    locale: str = None,
    signature_contains: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of built-in slot types that meet the specified criteria. For a list of built-in slot types, see Slot Type Reference in the Alexa Skills Kit. This operation requires permission for the lex:GetBuiltInSlotTypes action.

    Args:
        locale(str, optional): A list of locales that the slot type supports. Defaults to None.
        signature_contains(str, optional): Substring to match in built-in slot type signatures. A slot type will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz.". Defaults to None.
        next_token(str, optional): A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the pagination token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of slot types to return in the response. The default is 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.builtin.slot_type_.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.builtin.slot_type.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_builtin_slot_types",
        op_kwargs={
            "locale": locale,
            "signatureContains": signature_contains,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
