"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, signature: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a built-in intent. This operation requires permission for the lex:GetBuiltinIntent action.

    Args:
        signature(str): The unique identifier for a built-in intent. To find the signature for an intent, see Standard Built-in Intents in the Alexa Skills Kit.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.builtin.intent.get(ctx, signature=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.builtin.intent.get signature=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_builtin_intent",
        op_kwargs={"signature": signature},
    )


async def get_all(
    hub,
    ctx,
    locale: str = None,
    signature_contains: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of built-in intents that meet the specified criteria. This operation requires permission for the lex:GetBuiltinIntents action.

    Args:
        locale(str, optional): A list of locales that the intent supports. Defaults to None.
        signature_contains(str, optional): Substring to match in built-in intent signatures. An intent will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an intent, see Standard Built-in Intents in the Alexa Skills Kit. Defaults to None.
        next_token(str, optional): A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, use the pagination token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of intents to return in the response. The default is 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.builtin.intent.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.builtin.intent.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_builtin_intents",
        op_kwargs={
            "locale": locale,
            "signatureContains": signature_contains,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
