"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, next_token: str = None, max_results: int = None, name_contains: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns bot information as follows:    If you provide the nameContains field, the response includes information for the $LATEST version of all bots whose name contains the specified string.   If you don't specify the nameContains field, the operation returns information about the $LATEST version of all of your bots.   This operation requires permission for the lex:GetBots action.

    Args:
        next_token(str, optional): A pagination token that fetches the next page of bots. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of bots, specify the pagination token in the next request. . Defaults to None.
        max_results(int, optional): The maximum number of bots to return in the response that the request will return. The default is 10. Defaults to None.
        name_contains(str, optional): Substring to match in bot names. A bot will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz.". Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bots.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bots.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_bots",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "nameContains": name_contains,
        },
    )
