"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, checksum: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of the bot based on the $LATEST version. If the $LATEST version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version. It returns the last created version.  You can update only the $LATEST version of the bot. You can't update the numbered versions that you create with the CreateBotVersion operation.   When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see versioning-intro.   This operation requires permission for the lex:CreateBotVersion action.

    Args:
        name(str): The name of the bot that you want to create a new version of. The name is case sensitive. .
        checksum(str, optional): Identifies a specific revision of the $LATEST version of the bot. If you specify a checksum and the $LATEST version of the bot has a different checksum, a PreconditionFailedException exception is returned and Amazon Lex doesn't publish a new version. If you don't specify a checksum, Amazon Lex publishes the $LATEST version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.version.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.version.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="create_bot_version",
        op_kwargs={"name": name, "checksum": checksum},
    )


async def delete(hub, ctx, name: str, version: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a specific version of a bot. To delete all versions of a bot, use the DeleteBot operation.  This operation requires permissions for the lex:DeleteBotVersion action.

    Args:
        name(str): The name of the bot.
        version(str): The version of the bot to delete. You cannot delete the $LATEST version of the bot. To delete the $LATEST version, use the DeleteBot operation.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.version.delete(ctx, name=value, version=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.version.delete name=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="delete_bot_version",
        op_kwargs={"name": name, "version": version},
    )


async def get_all(
    hub, ctx, name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about all of the versions of a bot. The GetBotVersions operation returns a BotMetadata object for each version of a bot. For example, if a bot has three numbered versions, the GetBotVersions operation returns four BotMetadata objects in the response, one for each numbered version and one for the $LATEST version.  The GetBotVersions operation always returns at least one version, the $LATEST version. This operation requires permissions for the lex:GetBotVersions action.

    Args:
        name(str): The name of the bot for which versions should be returned.
        next_token(str, optional): A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. . Defaults to None.
        max_results(int, optional): The maximum number of bot versions to return in the response. The default is 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.version.get_all(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.version.get_all name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_bot_versions",
        op_kwargs={"name": name, "nextToken": next_token, "maxResults": max_results},
    )
