"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, name: str, bot_name: str, bot_alias: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the association between an Amazon Lex bot and a messaging platform. This operation requires permission for the lex:DeleteBotChannelAssociation action.

    Args:
        name(str): The name of the association. The name is case sensitive. .
        bot_name(str): The name of the Amazon Lex bot.
        bot_alias(str): An alias that points to the specific version of the Amazon Lex bot to which this association is being made.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.channel_association.delete(
                ctx, name=value, bot_name=value, bot_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.channel_association.delete name=value, bot_name=value, bot_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="delete_bot_channel_association",
        op_kwargs={"name": name, "botName": bot_name, "botAlias": bot_alias},
    )


async def get(hub, ctx, name: str, bot_name: str, bot_alias: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the association between an Amazon Lex bot and a messaging platform. This operation requires permissions for the lex:GetBotChannelAssociation action.

    Args:
        name(str): The name of the association between the bot and the channel. The name is case sensitive. .
        bot_name(str): The name of the Amazon Lex bot.
        bot_alias(str): An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.channel_association.get(
                ctx, name=value, bot_name=value, bot_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.channel_association.get name=value, bot_name=value, bot_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_bot_channel_association",
        op_kwargs={"name": name, "botName": bot_name, "botAlias": bot_alias},
    )


async def get_all(
    hub,
    ctx,
    bot_name: str,
    bot_alias: str,
    next_token: str = None,
    max_results: int = None,
    name_contains: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of all of the channels associated with the specified bot.  The GetBotChannelAssociations operation requires permissions for the lex:GetBotChannelAssociations action.

    Args:
        bot_name(str): The name of the Amazon Lex bot in the association.
        bot_alias(str): An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
        next_token(str, optional): A pagination token for fetching the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. . Defaults to None.
        max_results(int, optional): The maximum number of associations to return in the response. The default is 50. . Defaults to None.
        name_contains(str, optional): Substring to match in channel association names. An association will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot channel associations, use a hyphen ("-") as the nameContains parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.channel_association.get_all(
                ctx, bot_name=value, bot_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.channel_association.get_all bot_name=value, bot_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_bot_channel_associations",
        op_kwargs={
            "botName": bot_name,
            "botAlias": bot_alias,
            "nextToken": next_token,
            "maxResults": max_results,
            "nameContains": name_contains,
        },
    )
