"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    bot_name: str,
    next_token: str = None,
    max_results: int = None,
    name_contains: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of aliases for a specified Amazon Lex bot. This operation requires permissions for the lex:GetBotAliases action.

    Args:
        bot_name(str): The name of the bot.
        next_token(str, optional): A pagination token for fetching the next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. . Defaults to None.
        max_results(int, optional): The maximum number of aliases to return in the response. The default is 50. . . Defaults to None.
        name_contains(str, optional): Substring to match in bot alias names. An alias will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz.". Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.aliase.get_all(ctx, bot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.aliase.get_all bot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_bot_aliases",
        op_kwargs={
            "botName": bot_name,
            "nextToken": next_token,
            "maxResults": max_results,
            "nameContains": name_contains,
        },
    )
