"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, name: str, bot_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an alias for the specified bot.  You can't delete an alias that is used in the association between a bot and a messaging channel. If an alias is used in a channel association, the DeleteBot operation returns a ResourceInUseException exception that includes a reference to the channel association that refers to the bot. You can remove the reference to the alias by deleting the channel association. If you get the same exception again, delete the referring association until the DeleteBotAlias operation is successful.

    Args:
        name(str): The name of the alias to delete. The name is case sensitive. .
        bot_name(str): The name of the bot that the alias points to.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.alias.delete(ctx, name=value, bot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.alias.delete name=value, bot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="delete_bot_alias",
        op_kwargs={"name": name, "botName": bot_name},
    )


async def get(hub, ctx, name: str, bot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about an Amazon Lex bot alias. For more information about aliases, see versioning-aliases. This operation requires permissions for the lex:GetBotAlias action.

    Args:
        name(str): The name of the bot alias. The name is case sensitive.
        bot_name(str): The name of the bot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.alias.get(ctx, name=value, bot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.alias.get name=value, bot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_bot_alias",
        op_kwargs={"name": name, "botName": bot_name},
    )


async def put(
    hub,
    ctx,
    name: str,
    bot_version: str,
    bot_name: str,
    description: str = None,
    checksum: str = None,
    conversation_logs: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an alias for the specified version of the bot or replaces an alias for the specified bot. To change the version of the bot that the alias points to, replace the alias. For more information about aliases, see versioning-aliases. This operation requires permissions for the lex:PutBotAlias action.

    Args:
        name(str): The name of the alias. The name is not case sensitive.
        description(str, optional): A description of the alias. Defaults to None.
        bot_version(str): The version of the bot.
        bot_name(str): The name of the bot.
        checksum(str, optional): Identifies a specific revision of the $LATEST version. When you create a new bot alias, leave the checksum field blank. If you specify a checksum you get a BadRequestException exception. When you want to update a bot alias, set the checksum field to the checksum of the most recent revision of the $LATEST version. If you don't specify the  checksum field, or if the checksum does not match the $LATEST version, you get a PreconditionFailedException exception. Defaults to None.
        conversation_logs(Dict, optional): Settings for conversation logs for the alias. Defaults to None.
        tags(List, optional): A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the PutBotAlias operation to update the tags on a bot alias. To update tags, use the TagResource operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.bot.alias.put(
                ctx, name=value, bot_version=value, bot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.bot.alias.put name=value, bot_version=value, bot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="put_bot_alias",
        op_kwargs={
            "name": name,
            "description": description,
            "botVersion": bot_version,
            "botName": bot_name,
            "checksum": checksum,
            "conversationLogs": conversation_logs,
            "tags": tags,
        },
    )
