"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a function's tags. You can also view tags with GetFunction.

    Args:
        resource(str): The function's Amazon Resource Name (ARN).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.tags.list(ctx, resource=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.tags.list resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="list_tags",
        op_kwargs={"Resource": resource},
    )
