"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    function_name: str,
    statement_id: str,
    action: str,
    principal: str,
    source_arn: str = None,
    source_account: str = None,
    event_source_token: str = None,
    qualifier: str = None,
    revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Grants an Amazon Web Services service or another account permission to use a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function. To grant permission to another account, specify the account ID as the Principal. For Amazon Web Services services, the principal is a domain-style identifier defined by the service, like s3.amazonaws.com or sns.amazonaws.com. For Amazon Web Services services, you can also specify the ARN of the associated resource as the SourceArn. If you grant permission to a service principal without specifying the source, other accounts could potentially configure resources in their account to invoke your Lambda function. This action adds a statement to a resource-based permissions policy for the function. For more information about function policies, see Lambda Function Policies.

    Args:
        function_name(str): The name of the Lambda function, version, or alias.  Name formats     Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        statement_id(str): A statement identifier that differentiates the statement from others in the same policy.
        action(str): The action that the principal can use on the function. For example, lambda:InvokeFunction or lambda:GetFunction.
        principal(str): The Amazon Web Services service or account that invokes the function. If you specify a service, use SourceArn or SourceAccount to limit who can invoke the function through that service.
        source_arn(str, optional): For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic. Defaults to None.
        source_account(str, optional): For Amazon S3, the ID of the account that owns the resource. Use this together with SourceArn to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account. Defaults to None.
        event_source_token(str, optional): For Alexa Smart Home functions, a token that must be supplied by the invoker. Defaults to None.
        qualifier(str, optional): Specify a version or alias to add permissions to a published version of the function. Defaults to None.
        revision_id(str, optional): Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.permission.add(
                ctx, function_name=value, statement_id=value, action=value, principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.permission.add function_name=value, statement_id=value, action=value, principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="add_permission",
        op_kwargs={
            "FunctionName": function_name,
            "StatementId": statement_id,
            "Action": action,
            "Principal": principal,
            "SourceArn": source_arn,
            "SourceAccount": source_account,
            "EventSourceToken": event_source_token,
            "Qualifier": qualifier,
            "RevisionId": revision_id,
        },
    )


async def remove(
    hub,
    ctx,
    function_name: str,
    statement_id: str,
    qualifier: str = None,
    revision_id: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Revokes function-use permission from an Amazon Web Services service or another account. You can get the ID of the statement from the output of GetPolicy.

    Args:
        function_name(str): The name of the Lambda function, version, or alias.  Name formats     Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        statement_id(str): Statement ID of the permission to remove.
        qualifier(str, optional): Specify a version or alias to remove permissions from a published version of the function. Defaults to None.
        revision_id(str, optional): Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.permission.remove(
                ctx, function_name=value, statement_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.permission.remove function_name=value, statement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="remove_permission",
        op_kwargs={
            "FunctionName": function_name,
            "StatementId": statement_id,
            "Qualifier": qualifier,
            "RevisionId": revision_id,
        },
    )
