"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, layer_name: str, version_number: int) -> Dict:
    r"""
    **Autogenerated function**

    Returns the permission policy for a version of an Lambda layer. For more information, see AddLayerVersionPermission.

    Args:
        layer_name(str): The name or Amazon Resource Name (ARN) of the layer.
        version_number(int): The version number.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.layer.version.policy.get(
                ctx, layer_name=value, version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.layer.version.policy.get layer_name=value, version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_layer_version_policy",
        op_kwargs={"LayerName": layer_name, "VersionNumber": version_number},
    )
