"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    layer_name: str,
    version_number: int,
    statement_id: str,
    action: str,
    principal: str,
    organization_id: str = None,
    revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds permissions to the resource-based policy of a version of an Lambda layer. Use this action to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in an organization, or all Amazon Web Services accounts.  To revoke permission, call RemoveLayerVersionPermission with the statement ID that you specified when you added it.

    Args:
        layer_name(str): The name or Amazon Resource Name (ARN) of the layer.
        version_number(int): The version number.
        statement_id(str): An identifier that distinguishes the policy from others on the same layer version.
        action(str): The API action that grants access to the layer. For example, lambda:GetLayerVersion.
        principal(str): An account ID, or * to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if organizationId is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. .
        organization_id(str, optional): With the principal set to *, grant permission to all accounts in the specified organization. Defaults to None.
        revision_id(str, optional): Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.layer.version.permission.add(
                ctx,
                layer_name=value,
                version_number=value,
                statement_id=value,
                action=value,
                principal=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.layer.version.permission.add layer_name=value, version_number=value, statement_id=value, action=value, principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="add_layer_version_permission",
        op_kwargs={
            "LayerName": layer_name,
            "VersionNumber": version_number,
            "StatementId": statement_id,
            "Action": action,
            "Principal": principal,
            "OrganizationId": organization_id,
            "RevisionId": revision_id,
        },
    )


async def remove(
    hub,
    ctx,
    layer_name: str,
    version_number: int,
    statement_id: str,
    revision_id: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Removes a statement from the permissions policy for a version of an Lambda layer. For more information, see AddLayerVersionPermission.

    Args:
        layer_name(str): The name or Amazon Resource Name (ARN) of the layer.
        version_number(int): The version number.
        statement_id(str): The identifier that was specified when the statement was added.
        revision_id(str, optional): Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.layer.version.permission.remove(
                ctx, layer_name=value, version_number=value, statement_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.layer.version.permission.remove layer_name=value, version_number=value, statement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="remove_layer_version_permission",
        op_kwargs={
            "LayerName": layer_name,
            "VersionNumber": version_number,
            "StatementId": statement_id,
            "RevisionId": revision_id,
        },
    )
