"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, layer_name: str, version_number: int) -> None:
    r"""
    **Autogenerated function**

    Deletes a version of an Lambda layer. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of the version remains in Lambda until no functions refer to it.

    Args:
        layer_name(str): The name or Amazon Resource Name (ARN) of the layer.
        version_number(int): The version number.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.layer.version.init.delete(
                ctx, layer_name=value, version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.layer.version.init.delete layer_name=value, version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="delete_layer_version",
        op_kwargs={"LayerName": layer_name, "VersionNumber": version_number},
    )


async def get(hub, ctx, layer_name: str, version_number: int) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a version of an Lambda layer, with a link to download the layer archive that's valid for 10 minutes.

    Args:
        layer_name(str): The name or Amazon Resource Name (ARN) of the layer.
        version_number(int): The version number.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.layer.version.init.get(
                ctx, layer_name=value, version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.layer.version.init.get layer_name=value, version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_layer_version",
        op_kwargs={"LayerName": layer_name, "VersionNumber": version_number},
    )


async def list_all(
    hub,
    ctx,
    layer_name: str,
    compatible_runtime: str = None,
    marker: str = None,
    max_items: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of an Lambda layer. Versions that have been deleted aren't listed. Specify a runtime identifier to list only versions that indicate that they're compatible with that runtime.

    Args:
        compatible_runtime(str, optional): A runtime identifier. For example, go1.x. Defaults to None.
        layer_name(str): The name or Amazon Resource Name (ARN) of the layer.
        marker(str, optional): A pagination token returned by a previous call. Defaults to None.
        max_items(int, optional): The maximum number of versions to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.layer.version.init.list_all(ctx, layer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.layer.version.init.list_all layer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="list_layer_versions",
        op_kwargs={
            "CompatibleRuntime": compatible_runtime,
            "LayerName": layer_name,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )


async def publish(
    hub,
    ctx,
    layer_name: str,
    content: Dict,
    description: str = None,
    compatible_runtimes: List = None,
    license_info: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Lambda layer from a ZIP archive. Each time you call PublishLayerVersion with the same layer name, a new version is created. Add layers to your function with CreateFunction or UpdateFunctionConfiguration.

    Args:
        layer_name(str): The name or Amazon Resource Name (ARN) of the layer.
        description(str, optional): The description of the version. Defaults to None.
        content(Dict): The function layer archive.
        compatible_runtimes(List, optional): A list of compatible function runtimes. Used for filtering with ListLayers and ListLayerVersions. Defaults to None.
        license_info(str, optional): The layer's software license. It can be any of the following:   An SPDX license identifier. For example, MIT.   The URL of a license hosted on the internet. For example, https://opensource.org/licenses/MIT.   The full text of the license.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.layer.version.init.publish(
                ctx, layer_name=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.layer.version.init.publish layer_name=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="publish_layer_version",
        op_kwargs={
            "LayerName": layer_name,
            "Description": description,
            "Content": content,
            "CompatibleRuntimes": compatible_runtimes,
            "LicenseInfo": license_info,
        },
    )
