"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, compatible_runtime: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists Lambda layers and shows information about the latest version of each. Specify a runtime identifier to list only layers that indicate that they're compatible with that runtime.

    Args:
        compatible_runtime(str, optional): A runtime identifier. For example, go1.x. Defaults to None.
        marker(str, optional): A pagination token returned by a previous call. Defaults to None.
        max_items(int, optional): The maximum number of layers to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.layer.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.layer.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="list_layers",
        op_kwargs={
            "CompatibleRuntime": compatible_runtime,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )
