"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    function_name: str,
    role: str,
    code: Dict,
    runtime: str = None,
    handler: str = None,
    description: str = None,
    timeout: int = None,
    memory_size: int = None,
    publish: bool = None,
    vpc_config: Dict = None,
    package_type: str = None,
    dead_letter_config: Dict = None,
    environment: Dict = None,
    kms_key_arn: str = None,
    tracing_config: Dict = None,
    tags: Dict = None,
    layers: List = None,
    file_system_configs: List = None,
    image_config: Dict = None,
    code_signing_config_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Lambda function. To create a function, you need a deployment package and an execution role. The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing. You set the package type to Image if the deployment package is a container image. For a container image, the code property must include the URI of a container image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.  You set the package type to Zip if the deployment package is a .zip file archive. For a .zip file archive, the code property specifies the location of the .zip file. You must also specify the handler and runtime properties. When you create a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify the function. The State, StateReason, and StateReasonCode fields in the response from GetFunctionConfiguration indicate when the function is ready to invoke. For more information, see Function States. A function has an unpublished version, and can have published versions and aliases. The unpublished version changes when you update your function's code and configuration. A published version is a snapshot of your function code and configuration that can't be changed. An alias is a named resource that maps to a version, and can be changed to map to a different version. Use the Publish parameter to create version 1 of your function from its initial configuration. The other parameters let you configure version-specific and function-level settings. You can modify version-specific settings later with UpdateFunctionConfiguration. Function-level settings apply to both the unpublished and published versions of the function, and include tags (TagResource) and per-function concurrency limits (PutFunctionConcurrency). You can use code signing if your deployment package is a .zip file archive. To enable code signing for this function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with UpdateFunctionCode, Lambda checks that the code package has a valid signature from a trusted publisher. The code-signing configuration includes set set of signing profiles, which define the trusted publishers for this function. If another account or an Amazon Web Services service invokes your function, use AddPermission to grant permission by creating a resource-based IAM policy. You can grant permissions at the function level, on a version, or on an alias. To invoke your function directly, use Invoke. To invoke your function in response to events in other Amazon Web Services services, create an event source mapping (CreateEventSourceMapping), or configure a function trigger in the other service. For more information, see Invoking Functions.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - my-function.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        runtime(str, optional): The identifier of the function's runtime. Defaults to None.
        role(str): The Amazon Resource Name (ARN) of the function's execution role.
        handler(str, optional): The name of the method within your code that Lambda calls to execute your function. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see Programming Model. Defaults to None.
        code(Dict): The code for the function.
        description(str, optional): A description of the function. Defaults to None.
        timeout(int, optional): The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see Lambda execution environment. Defaults to None.
        memory_size(int, optional): The amount of memory available to the function at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB. Defaults to None.
        publish(bool, optional): Set to true to publish the first version of the function during creation. Defaults to None.
        vpc_config(Dict, optional): For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see VPC Settings. Defaults to None.
        package_type(str, optional): The type of deployment package. Set to Image for container image and set Zip for ZIP archive. Defaults to None.
        dead_letter_config(Dict, optional): A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see Dead Letter Queues. Defaults to None.
        environment(Dict, optional): Environment variables that are accessible from function code during execution. Defaults to None.
        kms_key_arn(str, optional): The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key. Defaults to None.
        tracing_config(Dict, optional): Set Mode to Active to sample and trace a subset of incoming requests with X-Ray. Defaults to None.
        tags(Dict, optional): A list of tags to apply to the function. Defaults to None.
        layers(List, optional): A list of function layers to add to the function's execution environment. Specify each layer by its ARN, including the version. Defaults to None.
        file_system_configs(List, optional): Connection settings for an Amazon EFS file system. Defaults to None.
        image_config(Dict, optional): Container image configuration values that override the values in the container image Dockerfile. Defaults to None.
        code_signing_config_arn(str, optional): To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.init.create(
                ctx, function_name=value, role=value, code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.init.create function_name=value, role=value, code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="create_function",
        op_kwargs={
            "FunctionName": function_name,
            "Runtime": runtime,
            "Role": role,
            "Handler": handler,
            "Code": code,
            "Description": description,
            "Timeout": timeout,
            "MemorySize": memory_size,
            "Publish": publish,
            "VpcConfig": vpc_config,
            "PackageType": package_type,
            "DeadLetterConfig": dead_letter_config,
            "Environment": environment,
            "KMSKeyArn": kms_key_arn,
            "TracingConfig": tracing_config,
            "Tags": tags,
            "Layers": layers,
            "FileSystemConfigs": file_system_configs,
            "ImageConfig": image_config,
            "CodeSigningConfigArn": code_signing_config_arn,
        },
    )


async def delete(hub, ctx, function_name: str, qualifier: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes a Lambda function. To delete a specific function version, use the Qualifier parameter. Otherwise, all versions and aliases are deleted. To delete Lambda event source mappings that invoke a function, use DeleteEventSourceMapping. For Amazon Web Services services and resources that invoke your function directly, delete the trigger in the service where you originally configured it.

    Args:
        function_name(str): The name of the Lambda function or version.  Name formats     Function name - my-function (name-only), my-function:1 (with version).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        qualifier(str, optional): Specify a version to delete. You can't delete a version that's referenced by an alias. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.init.delete(ctx, function_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.init.delete function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="delete_function",
        op_kwargs={"FunctionName": function_name, "Qualifier": qualifier},
    )


async def get(hub, ctx, function_name: str, qualifier: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the function or function version, with a link to download the deployment package that's valid for 10 minutes. If you specify a function version, only details that are specific to that version are returned.

    Args:
        function_name(str): The name of the Lambda function, version, or alias.  Name formats     Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        qualifier(str, optional): Specify a version or alias to get details about a published version of the function. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.init.get(ctx, function_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.init.get function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_function",
        op_kwargs={"FunctionName": function_name, "Qualifier": qualifier},
    )


async def list_all(
    hub,
    ctx,
    master_region: str = None,
    function_version: str = None,
    marker: str = None,
    max_items: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call. Set FunctionVersion to ALL to include all published versions of each function in addition to the unpublished version.   The ListFunctions action returns a subset of the FunctionConfiguration fields. To get the additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason, LastUpdateStatusReasonCode) for a function or version, use GetFunction.

    Args:
        master_region(str, optional): For Lambda@Edge functions, the Region of the master function. For example, us-east-1 filters the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set FunctionVersion to ALL. Defaults to None.
        function_version(str, optional): Set to ALL to include entries for all published versions of each function. Defaults to None.
        marker(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.
        max_items(int, optional): The maximum number of functions to return in the response. Note that ListFunctions returns a maximum of 50 items in each response, even if you set the number higher. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="list_functions",
        op_kwargs={
            "MasterRegion": master_region,
            "FunctionVersion": function_version,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )
