"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, function_name: str, qualifier: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the configuration for asynchronous invocation for a function, version, or alias. To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.

    Args:
        function_name(str): The name of the Lambda function, version, or alias.  Name formats     Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        qualifier(str, optional): A version number or alias name. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.event_invoke_config.delete(
                ctx, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.event_invoke_config.delete function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="delete_function_event_invoke_config",
        op_kwargs={"FunctionName": function_name, "Qualifier": qualifier},
    )


async def get(hub, ctx, function_name: str, qualifier: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the configuration for asynchronous invocation for a function, version, or alias. To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.

    Args:
        function_name(str): The name of the Lambda function, version, or alias.  Name formats     Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        qualifier(str, optional): A version number or alias name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.event_invoke_config.get(
                ctx, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.event_invoke_config.get function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_function_event_invoke_config",
        op_kwargs={"FunctionName": function_name, "Qualifier": qualifier},
    )


async def list_all(
    hub, ctx, function_name: str, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of configurations for asynchronous invocation for a function. To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - my-function.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        marker(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.
        max_items(int, optional): The maximum number of configurations to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.event_invoke_config.list_all(
                ctx, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.event_invoke_config.list_all function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="list_function_event_invoke_configs",
        op_kwargs={
            "FunctionName": function_name,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )


async def put(
    hub,
    ctx,
    function_name: str,
    qualifier: str = None,
    maximum_retry_attempts: int = None,
    maximum_event_age_in_seconds: int = None,
    destination_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Configures options for asynchronous invocation on a function, version, or alias. If a configuration already exists for a function, version, or alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without affecting existing settings for other options, use UpdateFunctionEventInvokeConfig. By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with UpdateFunctionConfiguration. To send an invocation record to a queue, topic, function, or event bus, specify a destination. You can configure separate destinations for successful invocations (on-success) and events that fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a dead-letter queue.

    Args:
        function_name(str): The name of the Lambda function, version, or alias.  Name formats     Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        qualifier(str, optional): A version number or alias name. Defaults to None.
        maximum_retry_attempts(int, optional): The maximum number of times to retry when the function returns an error. Defaults to None.
        maximum_event_age_in_seconds(int, optional): The maximum age of a request that Lambda sends to a function for processing. Defaults to None.
        destination_config(Dict, optional): A destination for events after they have been sent to a function for processing.  Destinations     Function - The Amazon Resource Name (ARN) of a Lambda function.    Queue - The ARN of an SQS queue.    Topic - The ARN of an SNS topic.    Event Bus - The ARN of an Amazon EventBridge event bus.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.event_invoke_config.put(
                ctx, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.event_invoke_config.put function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="put_function_event_invoke_config",
        op_kwargs={
            "FunctionName": function_name,
            "Qualifier": qualifier,
            "MaximumRetryAttempts": maximum_retry_attempts,
            "MaximumEventAgeInSeconds": maximum_event_age_in_seconds,
            "DestinationConfig": destination_config,
        },
    )


async def update(
    hub,
    ctx,
    function_name: str,
    qualifier: str = None,
    maximum_retry_attempts: int = None,
    maximum_event_age_in_seconds: int = None,
    destination_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration for asynchronous invocation for a function, version, or alias. To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.

    Args:
        function_name(str): The name of the Lambda function, version, or alias.  Name formats     Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        qualifier(str, optional): A version number or alias name. Defaults to None.
        maximum_retry_attempts(int, optional): The maximum number of times to retry when the function returns an error. Defaults to None.
        maximum_event_age_in_seconds(int, optional): The maximum age of a request that Lambda sends to a function for processing. Defaults to None.
        destination_config(Dict, optional): A destination for events after they have been sent to a function for processing.  Destinations     Function - The Amazon Resource Name (ARN) of a Lambda function.    Queue - The ARN of an SQS queue.    Topic - The ARN of an SNS topic.    Event Bus - The ARN of an Amazon EventBridge event bus.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.event_invoke_config.update(
                ctx, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.event_invoke_config.update function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="update_function_event_invoke_config",
        op_kwargs={
            "FunctionName": function_name,
            "Qualifier": qualifier,
            "MaximumRetryAttempts": maximum_retry_attempts,
            "MaximumEventAgeInSeconds": maximum_event_age_in_seconds,
            "DestinationConfig": destination_config,
        },
    )
