"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, function_name: str, qualifier: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the version-specific settings of a Lambda function or version. The output includes only options that can vary between versions of a function. To modify these settings, use UpdateFunctionConfiguration. To get all of a function's details, including function-level settings, use GetFunction.

    Args:
        function_name(str): The name of the Lambda function, version, or alias.  Name formats     Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        qualifier(str, optional): Specify a version or alias to get details about a published version of the function. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.configuration.get(ctx, function_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.configuration.get function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_function_configuration",
        op_kwargs={"FunctionName": function_name, "Qualifier": qualifier},
    )


async def update(
    hub,
    ctx,
    function_name: str,
    role: str = None,
    handler: str = None,
    description: str = None,
    timeout: int = None,
    memory_size: int = None,
    vpc_config: Dict = None,
    environment: Dict = None,
    runtime: str = None,
    dead_letter_config: Dict = None,
    kms_key_arn: str = None,
    tracing_config: Dict = None,
    revision_id: str = None,
    layers: List = None,
    file_system_configs: List = None,
    image_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modify the version-specific settings of a Lambda function. When you update a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but you can still invoke it. The LastUpdateStatus, LastUpdateStatusReason, and LastUpdateStatusReasonCode fields in the response from GetFunctionConfiguration indicate when the update is complete and the function is processing events with the new configuration. For more information, see Function States. These settings can vary between versions of a function and are locked when you publish a version. You can't modify the configuration of a published version, only the unpublished version. To configure function concurrency, use PutFunctionConcurrency. To grant invoke permissions to an account or Amazon Web Services service, use AddPermission.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - my-function.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        role(str, optional): The Amazon Resource Name (ARN) of the function's execution role. Defaults to None.
        handler(str, optional): The name of the method within your code that Lambda calls to execute your function. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see Programming Model. Defaults to None.
        description(str, optional): A description of the function. Defaults to None.
        timeout(int, optional): The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see Lambda execution environment. Defaults to None.
        memory_size(int, optional): The amount of memory available to the function at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB. Defaults to None.
        vpc_config(Dict, optional): For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see VPC Settings. Defaults to None.
        environment(Dict, optional): Environment variables that are accessible from function code during execution. Defaults to None.
        runtime(str, optional): The identifier of the function's runtime. Defaults to None.
        dead_letter_config(Dict, optional): A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see Dead Letter Queues. Defaults to None.
        kms_key_arn(str, optional): The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key. Defaults to None.
        tracing_config(Dict, optional): Set Mode to Active to sample and trace a subset of incoming requests with X-Ray. Defaults to None.
        revision_id(str, optional): Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it. Defaults to None.
        layers(List, optional): A list of function layers to add to the function's execution environment. Specify each layer by its ARN, including the version. Defaults to None.
        file_system_configs(List, optional): Connection settings for an Amazon EFS file system. Defaults to None.
        image_config(Dict, optional):  Container image configuration values that override the values in the container image Dockerfile. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.configuration.update(ctx, function_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.configuration.update function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="update_function_configuration",
        op_kwargs={
            "FunctionName": function_name,
            "Role": role,
            "Handler": handler,
            "Description": description,
            "Timeout": timeout,
            "MemorySize": memory_size,
            "VpcConfig": vpc_config,
            "Environment": environment,
            "Runtime": runtime,
            "DeadLetterConfig": dead_letter_config,
            "KMSKeyArn": kms_key_arn,
            "TracingConfig": tracing_config,
            "RevisionId": revision_id,
            "Layers": layers,
            "FileSystemConfigs": file_system_configs,
            "ImageConfig": image_config,
        },
    )
