"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, function_name: str) -> None:
    r"""
    **Autogenerated function**

    Removes a concurrent execution limit from a function.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - my-function.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.concurrency.delete(ctx, function_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.concurrency.delete function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="delete_function_concurrency",
        op_kwargs={"FunctionName": function_name},
    )


async def get(hub, ctx, function_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a function, use PutFunctionConcurrency.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - my-function.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.concurrency.get(ctx, function_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.concurrency.get function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_function_concurrency",
        op_kwargs={"FunctionName": function_name},
    )


async def put(
    hub, ctx, function_name: str, reserved_concurrent_executions: int
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency level. Concurrency settings apply to the function as a whole, including all published versions and the unpublished version. Reserving concurrency both ensures that your function has capacity to process the specified number of events simultaneously, and prevents it from scaling beyond that level. Use GetFunction to see the current setting for a function. Use GetAccountSettings to see your Regional concurrency limit. You can reserve concurrency for as many functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that aren't configured with a per-function limit. For more information, see Managing Concurrency.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - my-function.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        reserved_concurrent_executions(int): The number of simultaneous executions to reserve for the function.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.concurrency.put(
                ctx, function_name=value, reserved_concurrent_executions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.concurrency.put function_name=value, reserved_concurrent_executions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="put_function_concurrency",
        op_kwargs={
            "FunctionName": function_name,
            "ReservedConcurrentExecutions": reserved_concurrent_executions,
        },
    )
