"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, function_name: str) -> None:
    r"""
    **Autogenerated function**

    Removes the code signing configuration from the function.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.code.signing_config.delete(
                ctx, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.code.signing_config.delete function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="delete_function_code_signing_config",
        op_kwargs={"FunctionName": function_name},
    )


async def get(hub, ctx, function_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the code signing configuration for the specified function.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.code.signing_config.get(
                ctx, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.code.signing_config.get function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_function_code_signing_config",
        op_kwargs={"FunctionName": function_name},
    )


async def put(hub, ctx, code_signing_config_arn: str, function_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Update the code signing configuration for the function. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.

    Args:
        code_signing_config_arn(str): The The Amazon Resource Name (ARN) of the code signing configuration.
        function_name(str): The name of the Lambda function.  Name formats     Function name - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.code.signing_config.put(
                ctx, code_signing_config_arn=value, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.code.signing_config.put code_signing_config_arn=value, function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="put_function_code_signing_config",
        op_kwargs={
            "CodeSigningConfigArn": code_signing_config_arn,
            "FunctionName": function_name,
        },
    )
