"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    function_name: str,
    zip_file: bytes = None,
    s3_bucket: str = None,
    s3_key: str = None,
    s3_object_version: str = None,
    image_uri: str = None,
    publish: bool = None,
    dry_run: bool = None,
    revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by a trusted publisher. For more information, see Configuring code signing. The function's code is locked when you publish a version. You can't modify the code of a published version, only the unpublished version.  For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if you update the image tag to a new image, Lambda does not automatically update the function.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - my-function.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        zip_file(bytes, optional): The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you. Defaults to None.
        s3_bucket(str, optional): An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account. Defaults to None.
        s3_key(str, optional): The Amazon S3 key of the deployment package. Defaults to None.
        s3_object_version(str, optional): For versioned objects, the version of the deployment package object to use. Defaults to None.
        image_uri(str, optional): URI of a container image in the Amazon ECR registry. Defaults to None.
        publish(bool, optional): Set to true to publish a new version of the function after updating the code. This has the same effect as calling PublishVersion separately. Defaults to None.
        dry_run(bool, optional): Set to true to validate the request parameters and access permissions without modifying the function code. Defaults to None.
        revision_id(str, optional): Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.code.init.update(ctx, function_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.code.init.update function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="update_function_code",
        op_kwargs={
            "FunctionName": function_name,
            "ZipFile": zip_file,
            "S3Bucket": s3_bucket,
            "S3Key": s3_key,
            "S3ObjectVersion": s3_object_version,
            "ImageUri": image_uri,
            "Publish": publish,
            "DryRun": dry_run,
            "RevisionId": revision_id,
        },
    )
