"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, code_signing_config_arn: str, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the functions that use the specified code signing configuration. You can use this method prior to deleting a code signing configuration, to verify that no functions are using it.

    Args:
        code_signing_config_arn(str): The The Amazon Resource Name (ARN) of the code signing configuration.
        marker(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.
        max_items(int, optional): Maximum number of items to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.function.by_code_signing_config.list(
                ctx, code_signing_config_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.function.by_code_signing_config.list code_signing_config_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="list_functions_by_code_signing_config",
        op_kwargs={
            "CodeSigningConfigArn": code_signing_config_arn,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )
