"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    allowed_publishers: Dict,
    description: str = None,
    code_signing_policies: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a code signing configuration. A code signing configuration defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail).

    Args:
        description(str, optional): Descriptive name for this code signing configuration. Defaults to None.
        allowed_publishers(Dict): Signing profiles for this code signing configuration.
        code_signing_policies(Dict, optional): The code signing policies define the actions to take if the validation checks fail. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.code_signing_config.create(
                ctx, allowed_publishers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.code_signing_config.create allowed_publishers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="create_code_signing_config",
        op_kwargs={
            "Description": description,
            "AllowedPublishers": allowed_publishers,
            "CodeSigningPolicies": code_signing_policies,
        },
    )


async def delete(hub, ctx, code_signing_config_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the code signing configuration. You can delete the code signing configuration only if no function is using it.

    Args:
        code_signing_config_arn(str): The The Amazon Resource Name (ARN) of the code signing configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.code_signing_config.delete(
                ctx, code_signing_config_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.code_signing_config.delete code_signing_config_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="delete_code_signing_config",
        op_kwargs={"CodeSigningConfigArn": code_signing_config_arn},
    )


async def get(hub, ctx, code_signing_config_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified code signing configuration.

    Args:
        code_signing_config_arn(str): The The Amazon Resource Name (ARN) of the code signing configuration. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.code_signing_config.get(
                ctx, code_signing_config_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.code_signing_config.get code_signing_config_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_code_signing_config",
        op_kwargs={"CodeSigningConfigArn": code_signing_config_arn},
    )


async def list_all(hub, ctx, marker: str = None, max_items: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of code signing configurations. A request returns up to 10,000 configurations per call. You can use the MaxItems parameter to return fewer configurations per call.

    Args:
        marker(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.
        max_items(int, optional): Maximum number of items to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.code_signing_config.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.code_signing_config.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="list_code_signing_configs",
        op_kwargs={"Marker": marker, "MaxItems": max_items},
    )


async def update(
    hub,
    ctx,
    code_signing_config_arn: str,
    description: str = None,
    allowed_publishers: Dict = None,
    code_signing_policies: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update the code signing configuration. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.

    Args:
        code_signing_config_arn(str): The The Amazon Resource Name (ARN) of the code signing configuration.
        description(str, optional): Descriptive name for this code signing configuration. Defaults to None.
        allowed_publishers(Dict, optional): Signing profiles for this code signing configuration. Defaults to None.
        code_signing_policies(Dict, optional): The code signing policy. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.code_signing_config.update(
                ctx, code_signing_config_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.code_signing_config.update code_signing_config_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="update_code_signing_config",
        op_kwargs={
            "CodeSigningConfigArn": code_signing_config_arn,
            "Description": description,
            "AllowedPublishers": allowed_publishers,
            "CodeSigningPolicies": code_signing_policies,
        },
    )
