"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "async"


async def invoke(hub, ctx, function_name: str, invoke_args: bytes) -> Dict:
    r"""
    **Autogenerated function**

     For asynchronous function invocation, use Invoke.  Invokes a function asynchronously.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - my-function.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN - 123456789012:function:my-function.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        invoke_args(bytes): The JSON that you want to provide to your Lambda function as input.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.async_.invoke(
                ctx, function_name=value, invoke_args=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.async.invoke function_name=value, invoke_args=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="invoke_async",
        op_kwargs={"FunctionName": function_name, "InvokeArgs": invoke_args},
    )
