"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    function_name: str,
    name: str,
    function_version: str,
    description: str = None,
    routing_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an alias for a Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a different version. You can also map an alias to split invocation requests between two versions. Use the RoutingConfig parameter to specify a second version and the percentage of invocation requests that it receives.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        name(str): The name of the alias.
        function_version(str): The function version that the alias invokes.
        description(str, optional): A description of the alias. Defaults to None.
        routing_config(Dict, optional): The routing configuration of the alias. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.alias.create(
                ctx, function_name=value, name=value, function_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.alias.create function_name=value, name=value, function_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="create_alias",
        op_kwargs={
            "FunctionName": function_name,
            "Name": name,
            "FunctionVersion": function_version,
            "Description": description,
            "RoutingConfig": routing_config,
        },
    )


async def delete(hub, ctx, function_name: str, name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Lambda function alias.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        name(str): The name of the alias.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.alias.delete(ctx, function_name=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.alias.delete function_name=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="delete_alias",
        op_kwargs={"FunctionName": function_name, "Name": name},
    )


async def get(hub, ctx, function_name: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns details about a Lambda function alias.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        name(str): The name of the alias.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.alias.get(ctx, function_name=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.alias.get function_name=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="get_alias",
        op_kwargs={"FunctionName": function_name, "Name": name},
    )


async def list_all(
    hub,
    ctx,
    function_name: str,
    function_version: str = None,
    marker: str = None,
    max_items: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of aliases for a Lambda function.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        function_version(str, optional): Specify a function version to only list aliases that invoke that version. Defaults to None.
        marker(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.
        max_items(int, optional): Limit the number of aliases returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.alias.list_all(ctx, function_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.alias.list_all function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="list_aliases",
        op_kwargs={
            "FunctionName": function_name,
            "FunctionVersion": function_version,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )


async def update(
    hub,
    ctx,
    function_name: str,
    name: str,
    function_version: str = None,
    description: str = None,
    routing_config: Dict = None,
    revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration of a Lambda function alias.

    Args:
        function_name(str): The name of the Lambda function.  Name formats     Function name - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
        name(str): The name of the alias.
        function_version(str, optional): The function version that the alias invokes. Defaults to None.
        description(str, optional): A description of the alias. Defaults to None.
        routing_config(Dict, optional): The routing configuration of the alias. Defaults to None.
        revision_id(str, optional): Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying an alias that has changed since you last read it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lambda_.alias.update(ctx, function_name=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lambda_.alias.update function_name=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lambda",
        operation="update_alias",
        op_kwargs={
            "FunctionName": function_name,
            "Name": name,
            "FunctionVersion": function_version,
            "Description": description,
            "RoutingConfig": routing_config,
            "RevisionId": revision_id,
        },
    )
