"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def search(
    hub,
    ctx,
    expression: List,
    next_token: str = None,
    max_results: int = None,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation allows a search on TABLE resources by LFTags. This will be used by admins who want to grant user permissions on certain LFTags. Before making a grant, the admin can use SearchTablesByLFTags to find all resources where the given LFTags are valid to verify whether the returned resources can be shared.

    Args:
        next_token(str, optional): A continuation token, if this is not the first call to retrieve this list. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        expression(List): A list of conditions (LFTag structures) to search for in table resources.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.table_by_lf_tag.search(ctx, expression=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.table_by_lf_tag.search expression=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="search_tables_by_lf_tags",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "CatalogId": catalog_id,
            "Expression": expression,
        },
    )
