"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, entries: List, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Batch operation to revoke permissions from the principal.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        entries(List): A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.revoke_permission.batch(ctx, entries=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.revoke_permission.batch entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="batch_revoke_permissions",
        op_kwargs={"CatalogId": catalog_id, "Entries": entries},
    )
