"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, resource: Dict, catalog_id: str = None, show_assigned_lf_tags: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the tags applied to a resource.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        resource(Dict): The resource for which you want to return tags.
        show_assigned_lf_tags(bool, optional): Indicates whether to show the assigned tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.resource.lf_tag.get_all(ctx, resource=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.resource.lf_tag.get_all resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="get_resource_lf_tags",
        op_kwargs={
            "CatalogId": catalog_id,
            "Resource": resource,
            "ShowAssignedLFTags": show_assigned_lf_tags,
        },
    )
