"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters the resource as managed by the Data Catalog. When you deregister a path, Lake Formation removes the path from the inline policy attached to your service-linked role.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource that you want to deregister.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.resource.init.deregister(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.resource.init.deregister resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="deregister_resource",
        op_kwargs={"ResourceArn": resource_arn},
    )


async def describe(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current data access role for the given resource registered in AWS Lake Formation.

    Args:
        resource_arn(str): The resource ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.resource.init.describe(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.resource.init.describe resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="describe_resource",
        op_kwargs={"ResourceArn": resource_arn},
    )


async def list_all(
    hub,
    ctx,
    filter_condition_list: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the resources registered to be managed by the Data Catalog.

    Args:
        filter_condition_list(List, optional): Any applicable row-level and/or column-level filtering conditions for the resources. Defaults to None.
        max_results(int, optional): The maximum number of resource results. Defaults to None.
        next_token(str, optional): A continuation token, if this is not the first call to retrieve these resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.resource.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.resource.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="list_resources",
        op_kwargs={
            "FilterConditionList": filter_condition_list,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def register(
    hub,
    ctx,
    resource_arn: str,
    use_service_linked_role: bool = None,
    role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers the resource as managed by the Data Catalog. To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role. When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When you register subsequent paths, Lake Formation adds the path to the existing policy. The following request registers a new location and gives AWS Lake Formation permission to use the service-linked role to access that location.  ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true  If UseServiceLinkedRole is not set to true, you must provide or set the RoleArn:  arn:aws:iam::12345:role/my-data-access-role

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource that you want to register.
        use_service_linked_role(bool, optional): Designates an AWS Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation. For more information, see Using Service-Linked Roles for Lake Formation. Defaults to None.
        role_arn(str, optional): The identifier for the role that registers the resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.resource.init.register(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.resource.init.register resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="register_resource",
        op_kwargs={
            "ResourceArn": resource_arn,
            "UseServiceLinkedRole": use_service_linked_role,
            "RoleArn": role_arn,
        },
    )


async def update(hub, ctx, role_arn: str, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the data access role used for vending access to the given (registered) resource in AWS Lake Formation.

    Args:
        role_arn(str): The new role to use for the given resource registered in AWS Lake Formation.
        resource_arn(str): The resource ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.resource.init.update(
                ctx, role_arn=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.resource.init.update role_arn=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="update_resource",
        op_kwargs={"RoleArn": role_arn, "ResourceArn": resource_arn},
    )
