"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def grant(
    hub,
    ctx,
    principal: Dict,
    resource: Dict,
    permissions: List,
    catalog_id: str = None,
    permissions_with_grant_option: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. For information about permissions, see Security and Access Control to Metadata and Data.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        principal(Dict): The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN. Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. .
        resource(Dict): The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data Catalog, databases, and tables.
        permissions(List): The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake Formation resources. .
        permissions_with_grant_option(List, optional): Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the Privileges. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.permission.grant(
                ctx, principal=value, resource=value, permissions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.permission.grant principal=value, resource=value, permissions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="grant_permissions",
        op_kwargs={
            "CatalogId": catalog_id,
            "Principal": principal,
            "Resource": resource,
            "Permissions": permissions,
            "PermissionsWithGrantOption": permissions_with_grant_option,
        },
    )


async def list_all(
    hub,
    ctx,
    catalog_id: str = None,
    principal: Dict = None,
    resource_type: str = None,
    resource: Dict = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER. This operation returns only those permissions that have been explicitly granted. For information about permissions, see Security and Access Control to Metadata and Data.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        principal(Dict, optional): Specifies a principal to filter the permissions returned. Defaults to None.
        resource_type(str, optional): Specifies a resource type to filter the permissions returned. Defaults to None.
        resource(Dict, optional): A resource where you will get a list of the principal permissions. This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns. Defaults to None.
        next_token(str, optional): A continuation token, if this is not the first call to retrieve this list. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.permission.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.permission.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="list_permissions",
        op_kwargs={
            "CatalogId": catalog_id,
            "Principal": principal,
            "ResourceType": resource_type,
            "Resource": resource,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def revoke(
    hub,
    ctx,
    principal: Dict,
    resource: Dict,
    permissions: List,
    catalog_id: str = None,
    permissions_with_grant_option: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        principal(Dict): The principal to be revoked permissions on the resource.
        resource(Dict): The resource to which permissions are to be revoked.
        permissions(List): The permissions revoked to the principal on the resource. For information about permissions, see Security and Access Control to Metadata and Data.
        permissions_with_grant_option(List, optional): Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.permission.revoke(
                ctx, principal=value, resource=value, permissions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.permission.revoke principal=value, resource=value, permissions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="revoke_permissions",
        op_kwargs={
            "CatalogId": catalog_id,
            "Principal": principal,
            "Resource": resource,
            "Permissions": permissions,
            "PermissionsWithGrantOption": permissions_with_grant_option,
        },
    )
