"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, resource: Dict, lf_tags: List, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Attaches one or more tags to an existing resource.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        resource(Dict): The resource to which to attach a tag.
        lf_tags(List): The tags to attach to the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.lf_tags.to_resource.add(
                ctx, resource=value, lf_tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.lf_tags.to_resource.add resource=value, lf_tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="add_lf_tags_to_resource",
        op_kwargs={"CatalogId": catalog_id, "Resource": resource, "LFTags": lf_tags},
    )
