"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def remove(
    hub, ctx, resource: Dict, lf_tags: List, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag columns, use the column inclusion list in tableWithColumns to specify column input.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        resource(Dict): The resource where you want to remove a tag.
        lf_tags(List): The tags to be removed from the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.lf_tags.from_resource.remove(
                ctx, resource=value, lf_tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.lf_tags.from_resource.remove resource=value, lf_tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="remove_lf_tags_from_resource",
        op_kwargs={"CatalogId": catalog_id, "Resource": resource, "LFTags": lf_tags},
    )
