"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, tag_key: str, tag_values: List, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a tag with the specified name and values.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        tag_key(str): The key-name for the tag.
        tag_values(List): A list of possible values an attribute can take.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.lf_tag.create(
                ctx, tag_key=value, tag_values=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.lf_tag.create tag_key=value, tag_values=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="create_lf_tag",
        op_kwargs={"CatalogId": catalog_id, "TagKey": tag_key, "TagValues": tag_values},
    )


async def delete(hub, ctx, tag_key: str, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified tag key name. If the attribute key does not exist or the tag does not exist, then the operation will not do anything. If the attribute key exists, then the operation checks if any resources are tagged with this attribute key, if yes, the API throws a 400 Exception with the message "Delete not allowed" as the tag key is still attached with resources. You can consider untagging resources with this tag key.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        tag_key(str): The key-name for the tag to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.lf_tag.delete(ctx, tag_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.lf_tag.delete tag_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="delete_lf_tag",
        op_kwargs={"CatalogId": catalog_id, "TagKey": tag_key},
    )


async def get(hub, ctx, tag_key: str, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a tag definition.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        tag_key(str): The key-name for the tag.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.lf_tag.get(ctx, tag_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.lf_tag.get tag_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="get_lf_tag",
        op_kwargs={"CatalogId": catalog_id, "TagKey": tag_key},
    )


async def list_all(
    hub,
    ctx,
    catalog_id: str = None,
    resource_share_type: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists tags that the requester has permission to view.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        resource_share_type(str, optional): If resource share type is ALL, returns both in-account tags and shared tags that the requester has permission to view. If resource share type is FOREIGN, returns all share tags that the requester can view. If no resource share type is passed, lists tags in the given catalog ID that the requester has permission to view. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): A continuation token, if this is not the first call to retrieve this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.lf_tag.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.lf_tag.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="list_lf_tags",
        op_kwargs={
            "CatalogId": catalog_id,
            "ResourceShareType": resource_share_type,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    tag_key: str,
    catalog_id: str = None,
    tag_values_to_delete: List = None,
    tag_values_to_add: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the list of possible values for the specified tag key. If the tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the tag key's value.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        tag_key(str): The key-name for the tag for which to add or delete values.
        tag_values_to_delete(List, optional): A list of tag values to delete from the tag. Defaults to None.
        tag_values_to_add(List, optional): A list of tag values to add from the tag. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.lf_tag.update(ctx, tag_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.lf_tag.update tag_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="update_lf_tag",
        op_kwargs={
            "CatalogId": catalog_id,
            "TagKey": tag_key,
            "TagValuesToDelete": tag_values_to_delete,
            "TagValuesToAdd": tag_values_to_add,
        },
    )
