"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    resource_arn: str,
    catalog_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3. GetEffectivePermissionsForPath will not return databases and tables if the catalog is encrypted.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the resource for which you want to get permissions.
        next_token(str, optional): A continuation token, if this is not the first call to retrieve this list. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.effective_permission_for_path.get(
                ctx, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.effective_permission_for_path.get resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="get_effective_permissions_for_path",
        op_kwargs={
            "CatalogId": catalog_id,
            "ResourceArn": resource_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
