"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the list of the data lake administrators of a Lake Formation-managed data lake.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.data.lake_setting.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.data.lake_setting.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="get_data_lake_settings",
        op_kwargs={"CatalogId": catalog_id},
    )


async def put_multiple(
    hub, ctx, data_lake_settings: Dict, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation. For more information on admin privileges, see Granting Lake Formation Permissions. This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the current list and add the new admin to that list and pass that list in this API.

    Args:
        catalog_id(str, optional): The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. . Defaults to None.
        data_lake_settings(Dict): A structure representing a list of AWS Lake Formation principals designated as data lake administrators.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lakeformation.data.lake_setting.put_multiple(
                ctx, data_lake_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lakeformation.data.lake_setting.put_multiple data_lake_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lakeformation",
        operation="put_data_lake_settings",
        op_kwargs={"CatalogId": catalog_id, "DataLakeSettings": data_lake_settings},
    )
