"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, retiring_principal: str, limit: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all grants in the AWS account and Region that have the specified retiring principal. For more information about grants, see Grants in the  AWS Key Management Service Developer Guide . You can specify any principal in your AWS account. The grants that are returned include grants for CMKs in your AWS account and other AWS accounts. You might use this operation to determine which grants you may retire. To retire a grant, use the RetireGrant operation.  Cross-account use: You must specify a principal in your AWS account. However, this operation can return grants in any AWS account. You do not need kms:ListRetirableGrants permission (or any other additional permission) in any AWS account other than your own.  Required permissions: kms:ListRetirableGrants (IAM policy) in your AWS account.  Related operations:     CreateGrant     ListGrants     RetireGrant     RevokeGrant

    Args:
        limit(int, optional): Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer. This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50. Defaults to None.
        marker(str, optional): Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of NextMarker from the truncated response you just received. Defaults to None.
        retiring_principal(str): The retiring principal for which to list grants. Enter a principal in your AWS account. To specify the retiring principal, use the Amazon Resource Name (ARN) of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax for specifying a principal, see AWS Identity and Access Management (IAM) in the Example ARNs section of the Amazon Web Services General Reference.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.retirable_grant.list_all(ctx, retiring_principal=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.retirable_grant.list_all retiring_principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="list_retirable_grants",
        op_kwargs={
            "Limit": limit,
            "Marker": marker,
            "RetiringPrincipal": retiring_principal,
        },
    )
