"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, key_id: str, limit: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns all tags on the specified customer master key (CMK). For general information about tags, including the format and syntax, see Tagging AWS resources in the Amazon Web Services General Reference. For information about using tags in AWS KMS, see Tagging keys.  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.  Required permissions: kms:ListResourceTags (key policy)  Related operations:     CreateKey     ReplicateKey     TagResource     UntagResource

    Args:
        key_id(str): Gets tags on the specified customer master key (CMK). Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        limit(int, optional): Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer. This value is optional. If you include a value, it must be between 1 and 50, inclusive. If you do not include a value, it defaults to 50. Defaults to None.
        marker(str, optional): Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of NextMarker from the truncated response you just received. Do not attempt to construct this value. Use only the value of NextMarker from the truncated response you just received. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.resource.tag.list_all(ctx, key_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.resource.tag.list_all key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="list_resource_tags",
        op_kwargs={"KeyId": key_id, "Limit": limit, "Marker": marker},
    )
