"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def tag(hub, ctx, key_id: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds or edits tags on a customer managed CMK.  Tagging or untagging a CMK can allow or deny permission to the CMK. For details, see Using ABAC in AWS KMS in the AWS Key Management Service Developer Guide.  Each tag consists of a tag key and a tag value, both of which are case-sensitive strings. The tag value can be an empty (null) string. To add a tag, specify a new tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value. You can use this operation to tag a customer managed CMK, but you cannot tag an AWS managed CMK, an AWS owned CMK, a custom key store, or an alias. You can also add tags to a CMK while creating it (CreateKey) or replicating it (ReplicateKey). For information about using tags in AWS KMS, see Tagging keys. For general information about tags, including the format and syntax, see Tagging AWS resources in the Amazon Web Services General Reference.  The CMK that you use for this operation must be in a compatible key state. For details, see Key state: Effect on your CMK in the AWS Key Management Service Developer Guide.  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.   Required permissions: kms:TagResource (key policy)  Related operations     CreateKey     ListResourceTags     ReplicateKey     UntagResource

    Args:
        key_id(str): Identifies a customer managed CMK in the account and Region. Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        tags(List): One or more tags.  Each tag consists of a tag key and a tag value. The tag value can be an empty (null) string.  You cannot have more than one tag on a CMK with the same tag key. If you specify an existing tag key with a different tag value, AWS KMS replaces the current tag value with the specified one.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.resource.init.tag(ctx, key_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.resource.init.tag key_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="tag_resource",
        op_kwargs={"KeyId": key_id, "Tags": tags},
    )


async def untag(hub, ctx, key_id: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Deletes tags from a customer managed CMK. To delete a tag, specify the tag key and the CMK.  Tagging or untagging a CMK can allow or deny permission to the CMK. For details, see Using ABAC in AWS KMS in the AWS Key Management Service Developer Guide.  When it succeeds, the UntagResource operation doesn't return any output. Also, if the specified tag key isn't found on the CMK, it doesn't throw an exception or return a response. To confirm that the operation worked, use the ListResourceTags operation. For information about using tags in AWS KMS, see Tagging keys. For general information about tags, including the format and syntax, see Tagging AWS resources in the Amazon Web Services General Reference.  The CMK that you use for this operation must be in a compatible key state. For details, see Key state: Effect on your CMK in the AWS Key Management Service Developer Guide.  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.  Required permissions: kms:UntagResource (key policy)  Related operations     CreateKey     ListResourceTags     ReplicateKey     TagResource

    Args:
        key_id(str): Identifies the CMK from which you are removing tags. Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        tag_keys(List): One or more tag keys. Specify only the tag keys, not the tag values.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.resource.init.untag(ctx, key_id=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.resource.init.untag key_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="untag_resource",
        op_kwargs={"KeyId": key_id, "TagKeys": tag_keys},
    )
