"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def generate(
    hub, ctx, number_of_bytes: int = None, custom_key_store_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a random byte string that is cryptographically secure. By default, the random byte string is generated in AWS KMS. To generate the byte string in the AWS CloudHSM cluster that is associated with a custom key store, specify the custom key store ID. For more information about entropy and random number generation, see AWS Key Management Service Cryptographic Details.  Required permissions: kms:GenerateRandom (IAM policy)

    Args:
        number_of_bytes(int, optional): The length of the byte string. Defaults to None.
        custom_key_store_id(str, optional): Generates the random byte string in the AWS CloudHSM cluster that is associated with the specified custom key store. To find the ID of a custom key store, use the DescribeCustomKeyStores operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.random.generate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.random.generate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="generate_random",
        op_kwargs={
            "NumberOfBytes": number_of_bytes,
            "CustomKeyStoreId": custom_key_store_id,
        },
    )
