"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(hub, ctx, key_id: str, primary_region: str) -> None:
    r"""
    **Autogenerated function**

    Changes the primary key of a multi-Region key.  This operation changes the replica key in the specified Region to a primary key and changes the former primary key to a replica key. For example, suppose you have a primary key in us-east-1 and a replica key in eu-west-2. If you run UpdatePrimaryRegion with a PrimaryRegion value of eu-west-2, the primary key is now the key in eu-west-2, and the key in us-east-1 becomes a replica key. For details, see  This operation supports multi-Region keys, an AWS KMS feature that lets you create multiple interoperable CMKs in different AWS Regions. Because these CMKs have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information about multi-Region keys, see Using multi-Region keys in the AWS Key Management Service Developer Guide. The primary key of a multi-Region key is the source for properties that are always shared by primary and replica keys, including the key material, key ID, key spec, key usage, key material origin, and automatic key rotation. It's the only key that can be replicated. You cannot delete the primary key until all replicas are deleted. The key ID and primary Region that you specify uniquely identify the replica key that will become the primary key. The primary Region must already have a replica key. This operation does not create a CMK in the specified Region. To find the replica keys, use the DescribeKey operation on the primary key or any replica key. To create a replica key, use the ReplicateKey operation. You can run this operation while using the affected multi-Region keys in cryptographic operations. This operation should not delay, interrupt, or cause failures in cryptographic operations.  Even after this operation completes, the process of updating the primary Region might still be in progress for a few more seconds. Operations such as DescribeKey might display both the old and new primary keys as replicas. The old and new primary keys have a transient key state of Updating. The original key state is restored when the update is complete. While the key state is Updating, you can use the keys in cryptographic operations, but you cannot replicate the new primary key or perform certain management operations, such as enabling or disabling these keys. For details about the Updating key state, see Key state: Effect on your CMK in the AWS Key Management Service Developer Guide. This operation does not return any output. To verify that primary key is changed, use the DescribeKey operation.  Cross-account use: No. You cannot use this operation in a different AWS account.   Required permissions:     kms:UpdatePrimaryRegion on the current primary CMK (in the primary CMK's Region). Include this permission primary CMK's key policy.    kms:UpdatePrimaryRegion on the current replica CMK (in the replica CMK's Region). Include this permission in the replica CMK's key policy.    Related operations     CreateKey     ReplicateKey

    Args:
        key_id(str): Identifies the current primary key. When the operation completes, this CMK will be a replica key. Specify the key ID or key ARN of a multi-Region primary key. For example:   Key ID: mrk-1234abcd12ab34cd56ef1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        primary_region(str): The AWS Region of the new primary key. Enter the Region ID, such as us-east-1 or ap-southeast-2. There must be an existing replica key in this Region.  When the operation completes, the multi-Region key in this Region will be the primary key.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.primary_region.update(
                ctx, key_id=value, primary_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.primary_region.update key_id=value, primary_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="update_primary_region",
        op_kwargs={"KeyId": key_id, "PrimaryRegion": primary_region},
    )
