"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, limit: int = None, marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of all customer master keys (CMKs) in the caller's AWS account and Region.  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.  Required permissions: kms:ListKeys (IAM policy)  Related operations:     CreateKey     DescribeKey     ListAliases     ListResourceTags

    Args:
        limit(int, optional): Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer. This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100. Defaults to None.
        marker(str, optional): Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of NextMarker from the truncated response you just received. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.keys.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.keys.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="list_keys",
        op_kwargs={"Limit": limit, "Marker": marker},
    )
