"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def disable(hub, ctx, key_id: str) -> None:
    r"""
    **Autogenerated function**

    Disables automatic rotation of the key material for the specified symmetric customer master key (CMK).  You cannot enable automatic rotation of asymmetric CMKs, CMKs with imported key material, or CMKs in a custom key store. To enable or disable automatic rotation of a set of related multi-Region keys, set the property on the primary key.  The CMK that you use for this operation must be in a compatible key state. For details, see Key state: Effect on your CMK in the AWS Key Management Service Developer Guide.  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.  Required permissions: kms:DisableKeyRotation (key policy)  Related operations:     EnableKeyRotation     GetKeyRotationStatus

    Args:
        key_id(str): Identifies a symmetric customer master key (CMK). You cannot enable or disable automatic rotation of asymmetric CMKs, CMKs with imported key material, or CMKs in a custom key store. Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.key.rotation.init.disable(ctx, key_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.key.rotation.init.disable key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="disable_key_rotation",
        op_kwargs={"KeyId": key_id},
    )


async def enable(hub, ctx, key_id: str) -> None:
    r"""
    **Autogenerated function**

    Enables automatic rotation of the key material for the specified symmetric customer master key (CMK). You cannot enable automatic rotation of asymmetric CMKs, CMKs with imported key material, or CMKs in a custom key store. To enable or disable automatic rotation of a set of related multi-Region keys, set the property on the primary key. The CMK that you use for this operation must be in a compatible key state. For details, see Key state: Effect on your CMK in the AWS Key Management Service Developer Guide.  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.  Required permissions: kms:EnableKeyRotation (key policy)  Related operations:     DisableKeyRotation     GetKeyRotationStatus

    Args:
        key_id(str): Identifies a symmetric customer master key (CMK). You cannot enable automatic rotation of asymmetric CMKs, CMKs with imported key material, or CMKs in a custom key store. To enable or disable automatic rotation of a set of related multi-Region keys, set the property on the primary key. Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.key.rotation.init.enable(ctx, key_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.key.rotation.init.enable key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="enable_key_rotation",
        op_kwargs={"KeyId": key_id},
    )
