"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, key_id: str, policy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a key policy attached to the specified customer master key (CMK).  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.  Required permissions: kms:GetKeyPolicy (key policy)  Related operations: PutKeyPolicy

    Args:
        key_id(str): Gets the key policy for the specified customer master key (CMK). Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        policy_name(str): Specifies the name of the key policy. The only valid name is default. To get the names of key policies, use ListKeyPolicies.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.key.policy.get(ctx, key_id=value, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.key.policy.get key_id=value, policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="get_key_policy",
        op_kwargs={"KeyId": key_id, "PolicyName": policy_name},
    )


async def list_all(
    hub, ctx, key_id: str, limit: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the names of the key policies that are attached to a customer master key (CMK). This operation is designed to get policy names that you can use in a GetKeyPolicy operation. However, the only valid policy name is default.   Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.  Required permissions: kms:ListKeyPolicies (key policy)  Related operations:     GetKeyPolicy     PutKeyPolicy

    Args:
        key_id(str): Gets the names of key policies for the specified customer master key (CMK). Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        limit(int, optional): Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer. This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100. Only one policy can be attached to a key. Defaults to None.
        marker(str, optional): Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of NextMarker from the truncated response you just received. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.key.policy.list_all(ctx, key_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.key.policy.list_all key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="list_key_policies",
        op_kwargs={"KeyId": key_id, "Limit": limit, "Marker": marker},
    )


async def put(
    hub,
    ctx,
    key_id: str,
    policy_name: str,
    policy: str,
    bypass_policy_lockout_safety_check: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Attaches a key policy to the specified customer master key (CMK).  For more information about key policies, see Key Policies in the AWS Key Management Service Developer Guide. For help writing and formatting a JSON policy document, see the IAM JSON Policy Reference in the  IAM User Guide . For examples of adding a key policy in multiple programming languages, see Setting a key policy in the AWS Key Management Service Developer Guide.  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.  Required permissions: kms:PutKeyPolicy (key policy)  Related operations: GetKeyPolicy

    Args:
        key_id(str): Sets the key policy on the specified customer master key (CMK). Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        policy_name(str): The name of the key policy. The only valid value is default.
        policy(str): The key policy to attach to the CMK. The key policy must meet the following criteria:   If you don't set BypassPolicyLockoutSafetyCheck to true, the key policy must allow the principal that is making the PutKeyPolicy request to make a subsequent PutKeyPolicy request on the CMK. This reduces the risk that the CMK becomes unmanageable. For more information, refer to the scenario in the Default Key Policy section of the AWS Key Management Service Developer Guide.   Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS. When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS. For more information, see Changes that I make are not always immediately visible in the AWS Identity and Access Management User Guide.   The key policy cannot exceed 32 kilobytes (32768 bytes). For more information, see Resource Quotas in the AWS Key Management Service Developer Guide.
        bypass_policy_lockout_safety_check(bool, optional): A flag to indicate whether to bypass the key policy lockout safety check.  Setting this value to true increases the risk that the CMK becomes unmanageable. Do not set this value to true indiscriminately. For more information, refer to the scenario in the Default Key Policy section in the AWS Key Management Service Developer Guide.  Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent PutKeyPolicy request on the CMK. The default value is false. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.key.policy.put(
                ctx, key_id=value, policy_name=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.key.policy.put key_id=value, policy_name=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="put_key_policy",
        op_kwargs={
            "KeyId": key_id,
            "PolicyName": policy_name,
            "Policy": policy,
            "BypassPolicyLockoutSafetyCheck": bypass_policy_lockout_safety_check,
        },
    )
