"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(hub, ctx, key_id: str, description: str) -> None:
    r"""
    **Autogenerated function**

    Updates the description of a customer master key (CMK). To see the description of a CMK, use DescribeKey.  The CMK that you use for this operation must be in a compatible key state. For details, see Key state: Effect on your CMK in the AWS Key Management Service Developer Guide.  Cross-account use: No. You cannot perform this operation on a CMK in a different AWS account.   Required permissions: kms:UpdateKeyDescription (key policy)  Related operations     CreateKey     DescribeKey

    Args:
        key_id(str): Updates the description of the specified customer master key (CMK). Specify the key ID or key ARN of the CMK. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        description(str): New description for the CMK.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.key.description.update(ctx, key_id=value, description=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.key.description.update key_id=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="update_key_description",
        op_kwargs={"KeyId": key_id, "Description": description},
    )
