"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    key_id: str,
    grantee_principal: str,
    operations: List,
    retiring_principal: str = None,
    constraints: Dict = None,
    grant_tokens: List = None,
    name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a grant to a customer master key (CMK).  A grant is a policy instrument that allows AWS principals to use AWS KMS customer master keys (CMKs) in cryptographic operations. It also can allow them to view a CMK (DescribeKey) and create and manage grants. When authorizing access to a CMK, grants are considered along with key policies and IAM policies. Grants are often used for temporary permissions because you can create one, use its permissions, and delete it without changing your key policies or IAM policies.  For detailed information about grants, including grant terminology, see Using grants in the  AWS Key Management Service Developer Guide . For examples of working with grants in several programming languages, see Programming grants. The CreateGrant operation returns a GrantToken and a GrantId.   When you create, retire, or revoke a grant, there might be a brief delay, usually less than five minutes, until the grant is available throughout AWS KMS. This state is known as eventual consistency. Once the grant has achieved eventual consistency, the grantee principal can use the permissions in the grant without identifying the grant.  However, to use the permissions in the grant immediately, use the GrantToken that CreateGrant returns. For details, see Using a grant token in the  AWS Key Management Service Developer Guide .   The CreateGrant operation also returns a GrantId. You can use the GrantId and a key identifier to identify the grant in the RetireGrant and RevokeGrant operations. To find the grant ID, use the ListGrants or ListRetirableGrants operations.   For information about symmetric and asymmetric CMKs, see Using Symmetric and Asymmetric CMKs in the AWS Key Management Service Developer Guide. For more information about grants, see Grants in the  AWS Key Management Service Developer Guide . The CMK that you use for this operation must be in a compatible key state. For details, see Key state: Effect on your CMK in the AWS Key Management Service Developer Guide.  Cross-account use: Yes. To perform this operation on a CMK in a different AWS account, specify the key ARN in the value of the KeyId parameter.   Required permissions: kms:CreateGrant (key policy)  Related operations:     ListGrants     ListRetirableGrants     RetireGrant     RevokeGrant

    Args:
        key_id(str): Identifies the customer master key (CMK) for the grant. The grant gives principals permission to use this CMK. Specify the key ID or key ARN of the CMK. To specify a CMK in a different AWS account, you must use the key ARN. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        grantee_principal(str): The identity that gets the permissions specified in the grant. To specify the principal, use the Amazon Resource Name (ARN) of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, IAM roles, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see AWS Identity and Access Management (IAM) in the Example ARNs section of the AWS General Reference.
        retiring_principal(str, optional): The principal that is given permission to retire the grant by using RetireGrant operation. To specify the principal, use the Amazon Resource Name (ARN) of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see AWS Identity and Access Management (IAM) in the Example ARNs section of the AWS General Reference. Defaults to None.
        operations(List): A list of operations that the grant permits.  The operation must be supported on the CMK. For example, you cannot create a grant for a symmetric CMK that allows the Sign operation, or a grant for an asymmetric CMK that allows the GenerateDataKey operation. If you try, AWS KMS returns a ValidationError exception. For details, see Grant operations in the AWS Key Management Service Developer Guide.
        constraints(Dict, optional): Specifies a grant constraint.  AWS KMS supports the EncryptionContextEquals and EncryptionContextSubset grant constraints. Each constraint value can include up to 8 encryption context pairs. The encryption context value in each constraint cannot exceed 384 characters. These grant constraints allow a cryptographic operation only when the encryption context in the request matches (EncryptionContextEquals) or includes (EncryptionContextSubset) the encryption context specified in this structure. For more information about encryption context, see Encryption Context in the  AWS Key Management Service Developer Guide . For information about grant constraints, see Using grant constraints in the AWS Key Management Service Developer Guide. The encryption context grant constraints are supported only on operations that include an encryption context. You cannot use an encryption context grant constraint for cryptographic operations with asymmetric CMKs or for management operations, such as DescribeKey or RetireGrant. Defaults to None.
        grant_tokens(List, optional): A list of grant tokens.  Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved eventual consistency. For more information, see Grant token in the AWS Key Management Service Developer Guide. Defaults to None.
        name(str, optional): A friendly name for the grant. Use this value to prevent the unintended creation of duplicate grants when retrying this request. When this value is absent, all CreateGrant requests result in a new grant with a unique GrantId even if all the supplied parameters are identical. This can result in unintended duplicates when you retry the CreateGrant request. When this value is present, you can retry a CreateGrant request with identical parameters; if the grant already exists, the original GrantId is returned without creating a new grant. Note that the returned grant token is unique with every CreateGrant request, even when a duplicate GrantId is returned. All grant tokens for the same grant ID can be used interchangeably. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.grant.create(
                ctx, key_id=value, grantee_principal=value, operations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.grant.create key_id=value, grantee_principal=value, operations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="create_grant",
        op_kwargs={
            "KeyId": key_id,
            "GranteePrincipal": grantee_principal,
            "RetiringPrincipal": retiring_principal,
            "Operations": operations,
            "Constraints": constraints,
            "GrantTokens": grant_tokens,
            "Name": name,
        },
    )


async def list_all(
    hub,
    ctx,
    key_id: str,
    limit: int = None,
    marker: str = None,
    grant_id: str = None,
    grantee_principal: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of all grants for the specified customer master key (CMK).  You must specify the CMK in all requests. You can filter the grant list by grant ID or grantee principal.  The GranteePrincipal field in the ListGrants response usually contains the user or role designated as the grantee principal in the grant. However, when the grantee principal in the grant is an AWS service, the GranteePrincipal field contains the service principal, which might represent several different grantee principals.   Cross-account use: Yes. To perform this operation on a CMK in a different AWS account, specify the key ARN in the value of the KeyId parameter.  Required permissions: kms:ListGrants (key policy)  Related operations:     CreateGrant     ListRetirableGrants     RetireGrant     RevokeGrant

    Args:
        limit(int, optional): Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer. This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50. Defaults to None.
        marker(str, optional): Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of NextMarker from the truncated response you just received. Defaults to None.
        key_id(str): Returns only grants for the specified customer master key (CMK). This parameter is required. Specify the key ID or key ARN of the CMK. To specify a CMK in a different AWS account, you must use the key ARN. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        grant_id(str, optional): Returns only the grant with the specified grant ID. The grant ID uniquely identifies the grant. . Defaults to None.
        grantee_principal(str, optional): Returns only grants where the specified principal is the grantee principal for the grant. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.grant.list_all(ctx, key_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.grant.list_all key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="list_grants",
        op_kwargs={
            "Limit": limit,
            "Marker": marker,
            "KeyId": key_id,
            "GrantId": grant_id,
            "GranteePrincipal": grantee_principal,
        },
    )


async def retire(
    hub, ctx, grant_token: str = None, key_id: str = None, grant_id: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes a grant. Typically, you retire a grant when you no longer need its permissions. To identify the grant to retire, use a grant token, or both the grant ID and a key identifier (key ID or key ARN) of the customer master key (CMK). The CreateGrant operation returns both values. This operation can be called by the retiring principal for a grant, by the grantee principal if the grant allows the RetireGrant operation, and by the AWS account (root user) in which the grant is created. It can also be called by principals to whom permission for retiring a grant is delegated. For details, see Retiring and revoking grants in the AWS Key Management Service Developer Guide. For detailed information about grants, including grant terminology, see Using grants in the  AWS Key Management Service Developer Guide . For examples of working with grants in several programming languages, see Programming grants.  Cross-account use: Yes. You can retire a grant on a CMK in a different AWS account.  Required permissions::Permission to retire a grant is determined primarily by the grant. For details, see Retiring and revoking grants in the AWS Key Management Service Developer Guide.  Related operations:     CreateGrant     ListGrants     ListRetirableGrants     RevokeGrant

    Args:
        grant_token(str, optional): Identifies the grant to be retired. You can use a grant token to identify a new grant even before it has achieved eventual consistency. Only the CreateGrant operation returns a grant token. For details, see Grant token and Eventual consistency in the AWS Key Management Service Developer Guide. Defaults to None.
        key_id(str, optional): The key ARN CMK associated with the grant. To find the key ARN, use the ListKeys operation. For example: arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab . Defaults to None.
        grant_id(str, optional): Identifies the grant to retire. To get the grant ID, use CreateGrant, ListGrants, or ListRetirableGrants.   Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123  . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.grant.retire(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.grant.retire
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="retire_grant",
        op_kwargs={"GrantToken": grant_token, "KeyId": key_id, "GrantId": grant_id},
    )


async def revoke(hub, ctx, key_id: str, grant_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified grant. You revoke a grant to terminate the permissions that the grant allows. For more information, see Retiring and revoking grants in the  AWS Key Management Service Developer Guide . When you create, retire, or revoke a grant, there might be a brief delay, usually less than five minutes, until the grant is available throughout AWS KMS. This state is known as eventual consistency. For details, see Eventual consistency in the  AWS Key Management Service Developer Guide .   Cross-account use: Yes. To perform this operation on a CMK in a different AWS account, specify the key ARN in the value of the KeyId parameter.  Required permissions: kms:RevokeGrant (key policy).  Related operations:     CreateGrant     ListGrants     ListRetirableGrants     RetireGrant

    Args:
        key_id(str): A unique identifier for the customer master key (CMK) associated with the grant. To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. Specify the key ID or key ARN of the CMK. To specify a CMK in a different AWS account, you must use the key ARN. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
        grant_id(str): Identifies the grant to revoke. To get the grant ID, use CreateGrant, ListGrants, or ListRetirableGrants.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kms.grant.revoke(ctx, key_id=value, grant_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kms.grant.revoke key_id=value, grant_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kms",
        operation="revoke_grant",
        op_kwargs={"KeyId": key_id, "GrantId": grant_id},
    )
