"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, next_token: str = None, stream_arn: str = None, stream_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of tags associated with the specified stream. In the request, you must specify either the StreamName or the StreamARN.

    Args:
        next_token(str, optional): If you specify this parameter and the result of a ListTagsForStream call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags. Defaults to None.
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the stream that you want to list tags for. Defaults to None.
        stream_name(str, optional): The name of the stream that you want to list tags for. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.tags_for_.stream.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.tags_for_.stream.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="list_tags_for_stream",
        op_kwargs={
            "NextToken": next_token,
            "StreamARN": stream_arn,
            "StreamName": stream_name,
        },
    )
