"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource_arn: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of tags associated with the specified signaling channel.

    Args:
        next_token(str, optional): If you specify this parameter and the result of a ListTagsForResource call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags. . Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the signaling channel for which you want to list tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.tags_for_.resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.tags_for_.resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="list_tags_for_resource",
        op_kwargs={"NextToken": next_token, "ResourceARN": resource_arn},
    )
