"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    stream_name: str,
    device_name: str = None,
    media_type: str = None,
    kms_key_id: str = None,
    data_retention_in_hours: int = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Kinesis video stream.  When you create a new stream, Kinesis Video Streams assigns it a version number. When you change the stream's metadata, Kinesis Video Streams updates the version.   CreateStream is an asynchronous operation. For information about how the service works, see How it Works.  You must have permissions for the KinesisVideo:CreateStream action.

    Args:
        device_name(str, optional): The name of the device that is writing to the stream.   In the current implementation, Kinesis Video Streams does not use this name. . Defaults to None.
        stream_name(str): A name for the stream that you are creating. The stream name is an identifier for the stream, and must be unique for each account and region.
        media_type(str, optional): The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see Media Types. If you choose to specify the MediaType, see Naming Requirements for guidelines. Example valid values include "video/h264" and "video/h264,audio/aac". This parameter is optional; the default value is null (or empty in JSON). Defaults to None.
        kms_key_id(str, optional): The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data. If no key ID is specified, the default, Kinesis Video-managed key (aws/kinesisvideo) is used.  For more information, see DescribeKey. . Defaults to None.
        data_retention_in_hours(int, optional): The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream. The default value is 0, indicating that the stream does not persist data. When the DataRetentionInHours value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached. Defaults to None.
        tags(Dict, optional): A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.stream.create(ctx, stream_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.stream.create stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="create_stream",
        op_kwargs={
            "DeviceName": device_name,
            "StreamName": stream_name,
            "MediaType": media_type,
            "KmsKeyId": kms_key_id,
            "DataRetentionInHours": data_retention_in_hours,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, stream_arn: str, current_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Kinesis video stream and the data contained in the stream.  This method marks the stream for deletion, and makes the data in the stream inaccessible immediately.    To ensure that you have the latest version of the stream before deleting it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the DescribeStream API.  This operation requires permission for the KinesisVideo:DeleteStream action.

    Args:
        stream_arn(str): The Amazon Resource Name (ARN) of the stream that you want to delete. .
        current_version(str, optional): Optional: The version of the stream that you want to delete.  Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the DescribeStream API. If not specified, only the CreationTime is checked before deleting the stream. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.stream.delete(ctx, stream_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.stream.delete stream_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="delete_stream",
        op_kwargs={"StreamARN": stream_arn, "CurrentVersion": current_version},
    )


async def describe(hub, ctx, stream_name: str = None, stream_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the most current information about the specified stream. You must specify either the StreamName or the StreamARN.

    Args:
        stream_name(str, optional): The name of the stream. Defaults to None.
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the stream. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.stream.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.stream.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="describe_stream",
        op_kwargs={"StreamName": stream_name, "StreamARN": stream_arn},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    stream_name_condition: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of StreamInfo objects. Each object describes a stream. To retrieve only streams that satisfy a specific condition, you can specify a StreamNameCondition.

    Args:
        max_results(int, optional): The maximum number of streams to return in the response. The default is 10,000. Defaults to None.
        next_token(str, optional): If you specify this parameter, when the result of a ListStreams operation is truncated, the call returns the NextToken in the response. To get another batch of streams, provide this token in your next request. Defaults to None.
        stream_name_condition(Dict, optional): Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix of a stream name as a condition. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.stream.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.stream.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="list_streams",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "StreamNameCondition": stream_name_condition,
        },
    )


async def tag(
    hub, ctx, tags: Dict, stream_arn: str = None, stream_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more tags to a stream. A tag is a key-value pair (the value is optional) that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see Using Cost Allocation Tags in the AWS Billing and Cost Management User Guide.  You must provide either the StreamName or the StreamARN. This operation requires permission for the KinesisVideo:TagStream action. Kinesis video streams support up to 50 tags.

    Args:
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags to. Defaults to None.
        stream_name(str, optional): The name of the stream that you want to add the tag or tags to. Defaults to None.
        tags(Dict): A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.stream.tag(ctx, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.stream.tag tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="tag_stream",
        op_kwargs={"StreamARN": stream_arn, "StreamName": stream_name, "Tags": tags},
    )


async def untag(
    hub, ctx, tag_key_list: List, stream_arn: str = None, stream_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more tags from a stream. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored. In the request, you must provide the StreamName or StreamARN.

    Args:
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the stream that you want to remove tags from. Defaults to None.
        stream_name(str, optional): The name of the stream that you want to remove tags from. Defaults to None.
        tag_key_list(List): A list of the keys of the tags that you want to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.stream.untag(ctx, tag_key_list=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.stream.untag tag_key_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="untag_stream",
        op_kwargs={
            "StreamARN": stream_arn,
            "StreamName": stream_name,
            "TagKeyList": tag_key_list,
        },
    )


async def update(
    hub,
    ctx,
    current_version: str,
    stream_name: str = None,
    stream_arn: str = None,
    device_name: str = None,
    media_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates stream metadata, such as the device name and media type. You must provide the stream name or the Amazon Resource Name (ARN) of the stream. To make sure that you have the latest version of the stream before updating it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the DescribeStream API.   UpdateStream is an asynchronous operation, and takes time to complete.

    Args:
        stream_name(str, optional): The name of the stream whose metadata you want to update. The stream name is an identifier for the stream, and must be unique for each account and region. Defaults to None.
        stream_arn(str, optional): The ARN of the stream whose metadata you want to update. Defaults to None.
        current_version(str): The version of the stream whose metadata you want to update.
        device_name(str, optional): The name of the device that is writing to the stream.    In the current implementation, Kinesis Video Streams does not use this name.  . Defaults to None.
        media_type(str, optional): The stream's media type. Use MediaType to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see Media Types. If you choose to specify the MediaType, see Naming Requirements. To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify video/h264 as the MediaType. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.stream.update(ctx, current_version=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.stream.update current_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="update_stream",
        op_kwargs={
            "StreamName": stream_name,
            "StreamARN": stream_arn,
            "CurrentVersion": current_version,
            "DeviceName": device_name,
            "MediaType": media_type,
        },
    )
