"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    channel_name: str,
    channel_type: str = None,
    single_master_configuration: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a signaling channel.   CreateSignalingChannel is an asynchronous operation.

    Args:
        channel_name(str): A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS Region.
        channel_type(str, optional): A type of the signaling channel that you are creating. Currently, SINGLE_MASTER is the only supported channel type. . Defaults to None.
        single_master_configuration(Dict, optional): A structure containing the configuration for the SINGLE_MASTER channel type. . Defaults to None.
        tags(List, optional): A set of tags (key-value pairs) that you want to associate with this channel. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.signaling_channel.init.create(
                ctx, channel_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.signaling_channel.init.create channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="create_signaling_channel",
        op_kwargs={
            "ChannelName": channel_name,
            "ChannelType": channel_type,
            "SingleMasterConfiguration": single_master_configuration,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, channel_arn: str, current_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified signaling channel. DeleteSignalingChannel is an asynchronous operation. If you don't specify the channel's current version, the most recent version is deleted.

    Args:
        channel_arn(str): The Amazon Resource Name (ARN) of the signaling channel that you want to delete.
        current_version(str, optional): The current version of the signaling channel that you want to delete. You can obtain the current version by invoking the DescribeSignalingChannel or ListSignalingChannels API operations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.signaling_channel.init.delete(
                ctx, channel_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.signaling_channel.init.delete channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="delete_signaling_channel",
        op_kwargs={"ChannelARN": channel_arn, "CurrentVersion": current_version},
    )


async def describe(hub, ctx, channel_name: str = None, channel_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the most current information about the signaling channel. You must specify either the name or the Amazon Resource Name (ARN) of the channel that you want to describe.

    Args:
        channel_name(str, optional): The name of the signaling channel that you want to describe. Defaults to None.
        channel_arn(str, optional): The ARN of the signaling channel that you want to describe. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.signaling_channel.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.signaling_channel.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="describe_signaling_channel",
        op_kwargs={"ChannelName": channel_name, "ChannelARN": channel_arn},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    channel_name_condition: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of ChannelInfo objects. Each object describes a signaling channel. To retrieve only those channels that satisfy a specific condition, you can specify a ChannelNameCondition.

    Args:
        max_results(int, optional): The maximum number of channels to return in the response. The default is 500. Defaults to None.
        next_token(str, optional): If you specify this parameter, when the result of a ListSignalingChannels operation is truncated, the call returns the NextToken in the response. To get another batch of channels, provide this token in your next request. Defaults to None.
        channel_name_condition(Dict, optional): Optional: Returns only the channels that satisfy a specific condition. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.signaling_channel.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.signaling_channel.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="list_signaling_channels",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "ChannelNameCondition": channel_name_condition,
        },
    )


async def update(
    hub,
    ctx,
    channel_arn: str,
    current_version: str,
    single_master_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the existing signaling channel. This is an asynchronous operation and takes time to complete.  If the MessageTtlSeconds value is updated (either increased or reduced), it only applies to new messages sent via this channel after it's been updated. Existing messages are still expired as per the previous MessageTtlSeconds value.

    Args:
        channel_arn(str): The Amazon Resource Name (ARN) of the signaling channel that you want to update.
        current_version(str): The current version of the signaling channel that you want to update.
        single_master_configuration(Dict, optional): The structure containing the configuration for the SINGLE_MASTER type of the signaling channel that you want to update. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.signaling_channel.init.update(
                ctx, channel_arn=value, current_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.signaling_channel.init.update channel_arn=value, current_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="update_signaling_channel",
        op_kwargs={
            "ChannelARN": channel_arn,
            "CurrentVersion": current_version,
            "SingleMasterConfiguration": single_master_configuration,
        },
    )
